<?php

namespace IAWP;

/** @internal */
class Known_Referrers
{
    private static $referrers = [['name' => 'Google', 'type' => 'Search', 'domains' => ['www.google.com', 'www.google.ad', 'www.google.ae', 'www.google.com.af', 'www.google.com.ag', 'www.google.com.ai', 'www.google.al', 'www.google.am', 'www.google.co.ao', 'www.google.com.ar', 'www.google.as', 'www.google.at', 'www.google.com.au', 'www.google.az', 'www.google.ba', 'www.google.com.bd', 'www.google.be', 'www.google.bf', 'www.google.bg', 'www.google.com.bh', 'www.google.bi', 'www.google.bj', 'www.google.com.bn', 'www.google.com.bo', 'www.google.com.br', 'www.google.bs', 'www.google.bt', 'www.google.co.bw', 'www.google.by', 'www.google.com.bz', 'www.google.ca', 'www.google.cd', 'www.google.cf', 'www.google.cg', 'www.google.ch', 'www.google.ci', 'www.google.co.ck', 'www.google.cl', 'www.google.cm', 'www.google.cn', 'www.google.com.co', 'www.google.co.cr', 'www.google.com.cu', 'www.google.cv', 'www.google.com.cy', 'www.google.cz', 'www.google.de', 'www.google.dj', 'www.google.dk', 'www.google.dm', 'www.google.com.do', 'www.google.dz', 'www.google.com.ec', 'www.google.ee', 'www.google.com.eg', 'www.google.es', 'www.google.com.et', 'www.google.fi', 'www.google.com.fj', 'www.google.fm', 'www.google.fr', 'www.google.ga', 'www.google.ge', 'www.google.gg', 'www.google.com.gh', 'www.google.com.gi', 'www.google.gl', 'www.google.gm', 'www.google.gr', 'www.google.com.gt', 'www.google.gy', 'www.google.com.hk', 'www.google.hn', 'www.google.hr', 'www.google.ht', 'www.google.hu', 'www.google.co.id', 'www.google.ie', 'www.google.co.il', 'www.google.im', 'www.google.co.in', 'www.google.iq', 'www.google.is', 'www.google.it', 'www.google.je', 'www.google.com.jm', 'www.google.jo', 'www.google.co.jp', 'www.google.co.ke', 'www.google.com.kh', 'www.google.ki', 'www.google.kg', 'www.google.co.kr', 'www.google.com.kw', 'www.google.kz', 'www.google.la', 'www.google.com.lb', 'www.google.li', 'www.google.lk', 'www.google.co.ls', 'www.google.lt', 'www.google.lu', 'www.google.lv', 'www.google.com.ly', 'www.google.co.ma', 'www.google.md', 'www.google.me', 'www.google.mg', 'www.google.mk', 'www.google.ml', 'www.google.com.mm', 'www.google.mn', 'www.google.ms', 'www.google.com.mt', 'www.google.mu', 'www.google.mv', 'www.google.mw', 'www.google.com.mx', 'www.google.com.my', 'www.google.co.mz', 'www.google.com.na', 'www.google.com.ng', 'www.google.com.ni', 'www.google.ne', 'www.google.nl', 'www.google.no', 'www.google.com.np', 'www.google.nr', 'www.google.nu', 'www.google.co.nz', 'www.google.com.om', 'www.google.com.pa', 'www.google.com.pe', 'www.google.com.pg', 'www.google.com.ph', 'www.google.com.pk', 'www.google.pl', 'www.google.pn', 'www.google.com.pr', 'www.google.ps', 'www.google.pt', 'www.google.com.py', 'www.google.com.qa', 'www.google.ro', 'www.google.ru', 'www.google.rw', 'www.google.com.sa', 'www.google.com.sb', 'www.google.sc', 'www.google.se', 'www.google.com.sg', 'www.google.sh', 'www.google.si', 'www.google.sk', 'www.google.com.sl', 'www.google.sn', 'www.google.so', 'www.google.sm', 'www.google.sr', 'www.google.st', 'www.google.com.sv', 'www.google.td', 'www.google.tg', 'www.google.co.th', 'www.google.com.tj', 'www.google.tl', 'www.google.tm', 'www.google.tn', 'www.google.to', 'www.google.com.tr', 'www.google.tt', 'www.google.com.tw', 'www.google.co.tz', 'www.google.com.ua', 'www.google.co.ug', 'www.google.co.uk', 'www.google.com.uy', 'www.google.co.uz', 'www.google.com.vc', 'www.google.co.ve', 'www.google.vg', 'www.google.co.vi', 'www.google.com.vn', 'www.google.vu', 'www.google.ws', 'www.google.rs', 'www.google.co.za', 'www.google.co.zm', 'www.google.co.zw', 'www.google.cat', 'com.google.android.gm']], ['name' => 'Google Ads', 'type' => 'Ad', 'domains' => ['googleads.iawp']], ['name' => 'Google Display Network', 'type' => 'Ad', 'domains' => ['googleads.g.doubleclick.net']], ['name' => 'Google Docs', 'type' => 'Referrer', 'domains' => ['docs.google.com']], ['name' => 'Google Lens', 'type' => 'Search', 'domains' => ['lens.google.com']], ['name' => 'Gmail', 'type' => 'Referrer', 'domains' => ['mail.google.com']], ['name' => 'Yahoo', 'type' => 'Search', 'domains' => ['search.yahoo.com', 'at.search.yahoo.com', 'au.search.yahoo.com', 'be.search.yahoo.com', 'br.search.yahoo.com', 'ca.search.yahoo.com', 'ch.search.yahoo.com', 'de.search.yahoo.com', 'es.search.yahoo.com', 'espanol.search.yahoo.com', 'fi.search.yahoo.com', 'fr.search.yahoo.com', 'gr.search.yahoo.com', 'hk.search.yahoo.com', 'id.search.yahoo.com', 'ie.search.yahoo.com', 'il.search.yahoo.com', 'in.search.yahoo.com', 'it.search.yahoo.com', 'malaysia.search.yahoo.com', 'nl.search.yahoo.com', 'no.search.yahoo.com', 'pe.search.yahoo.com', 'ph.search.yahoo.com', 'pl.search.yahoo.com', 'qc.search.yahoo.com', 'r.search.yahoo.com', 'ro.search.yahoo.com', 'ru.search.yahoo.com', 'se.search.yahoo.com', 'sg.search.yahoo.com', 'th.search.yahoo.com', 'tr.search.yahoo.com', 'tw.search.yahoo.com', 'ua.search.yahoo.com', 'vn.search.yahoo.com', 'za.search.yahoo.com', 'uk.search.yahoo.com', 'us.search.yahoo.com', 'search.yahoo.co.jp', 'co.search.yahoo.com']], ['name' => 'Bing', 'type' => 'Search', 'domains' => ['bing.com', 'www.bing.com', 'cn.bing.com']], ['name' => 'Yandex', 'type' => 'Search', 'domains' => ['yandex.com', 'yandex.ru', 'yandex.ua', 'yandex.by', 'yandex.kz', 'yandex.uz', 'yandex.com.tr', 'yandex.fr', 'yandex.az', 'yandex.com.ge', 'yandex.com.am', 'yandex.co.il', 'yandex.lv', 'yandex.lt', 'yandex.ee', 'yandex.md', 'yandex.tm', 'yandex.tj']], ['name' => 'DuckDuckGo', 'type' => 'Search', 'domains' => ['duckduckgo.com']], ['name' => 'Ecosia', 'type' => 'Search', 'domains' => ['www.ecosia.org']], ['name' => 'Qwant', 'type' => 'Search', 'domains' => ['www.qwant.com']], ['name' => 'AlohaFind', 'type' => 'Search', 'domains' => ['alohafind.com']], ['name' => 'Brave', 'type' => 'Search', 'domains' => ['search.brave.com']], ['name' => 'Presearch', 'type' => 'Search', 'domains' => ['presearch.com']], ['name' => 'Twitter', 'type' => 'Social', 'domains' => ['twitter.com', 't.co', 'x.com']], ['name' => 'Facebook', 'type' => 'Social', 'domains' => ['www.facebook.com', 'm.facebook.com', 'lm.facebook.com', 'l.facebook.com']], ['name' => 'Facebook Ads', 'type' => 'Ad', 'domains' => ['facebookads.iawp']], ['name' => 'Instagram', 'type' => 'Social', 'domains' => ['instagram.com', 'www.instagram.com', 'l.instagram.com', 'lm.instagram.com']], ['name' => 'TikTok', 'type' => 'Social', 'domains' => ['www.tiktok.com']], ['name' => 'LinkedIn', 'type' => 'Social', 'domains' => ['www.linkedin.com', 'com.linkedin.android']], ['name' => 'Pinterest', 'type' => 'Social', 'domains' => ['pinterest.com', 'www.pinterest.com', 'com.pinterest', 'ar.pinterest.com', 'at.pinterest.com', 'au.pinterest.com', 'br.pinterest.com', 'ca.pinterest.com', 'ch.pinterest.com', 'cl.pinterest.com', 'cz.pinterest.com', 'de.pinterest.com', 'es.pinterest.com', 'fi.pinterest.com', 'fr.pinterest.com', 'gr.pinterest.com', 'hu.pinterest.com', 'in.pinterest.com', 'it.pinterest.com', 'jp.pinterest.com', 'mx.pinterest.com', 'nl.pinterest.com', 'nz.pinterest.com', 'ph.pinterest.com', 'pl.pinterest.com', 'pt.pinterest.com', 'ru.pinterest.com', 'sk.pinterest.com', 'tr.pinterest.com', 'uk.pinterest.com', 'za.pinterest.com']], ['name' => 'Pinterest iOS App', 'type' => 'Social', 'domains' => ['429047995']], ['name' => 'YouTube', 'type' => 'Social', 'domains' => ['youtube.com', 'www.youtube.com', 'm.youtube.com']], ['name' => 'AOL Search', 'type' => 'Search', 'domains' => ['search.aol.com']], ['name' => 'ArtStation', 'type' => 'Social', 'domains' => ['www.artstation.com']], ['name' => 'Baidu', 'type' => 'Search', 'domains' => ['baidu.com', 'www.baidu.com', 'm.baidu.com']], ['name' => 'Bandcamp', 'type' => 'Social', 'domains' => ['bandcamp.com']], ['name' => 'Behance', 'type' => 'Social', 'domains' => ['www.behance.net']], ['name' => 'Bitbucket', 'type' => 'Social', 'domains' => ['bitbucket.org']], ['name' => 'Bluesky', 'type' => 'Social', 'domains' => ['bsky.app', 'go.bsky.app']], ['name' => 'CodePen', 'type' => 'Social', 'domains' => ['codepen.io']], ['name' => 'DeviantArt', 'type' => 'Social', 'domains' => ['www.deviantart.com']], ['name' => 'Discord', 'type' => 'Social', 'domains' => ['discord.com']], ['name' => 'Dribble', 'type' => 'Social', 'domains' => ['dribbble.com']], ['name' => 'Flickr', 'type' => 'Social', 'domains' => ['flickr.com']], ['name' => 'GitHub', 'type' => 'Social', 'domains' => ['gist.github.com', 'github.com']], ['name' => 'Goodreads', 'type' => 'Social', 'domains' => ['www.goodreads.com']], ['name' => 'Hacker News', 'type' => 'Social', 'domains' => ['news.ycombinator.com']], ['name' => 'Mastodon', 'type' => 'Social', 'domains' => ['mastodon.social', 'org.joinmastodon.android']], ['name' => 'Meetup', 'type' => 'Social', 'domains' => ['www.meetup.com']], ['name' => 'Mixcloud', 'type' => 'Social', 'domains' => ['www.mixcloud.com']], ['name' => 'Patreon', 'type' => 'Social', 'domains' => ['www.patreon.com']], ['name' => 'PayPal', 'type' => 'Referrer', 'domains' => ['www.paypal.com']], ['name' => 'Quora', 'type' => 'Social', 'domains' => ['www.quora.com', 'bn.quora.com']], ['name' => 'Tencent QQ', 'type' => 'Social', 'domains' => ['www.qq.com']], ['name' => 'Ravelry', 'type' => 'Social', 'domains' => ['www.ravelry.com']], ['name' => 'Reddit', 'type' => 'Social', 'domains' => ['out.reddit.com', 'www.reddit.com']], ['name' => 'Slack', 'type' => 'Social', 'domains' => ['slack.com']], ['name' => 'SlideShare', 'type' => 'Social', 'domains' => ['www.slideshare.net']], ['name' => 'Snapchat', 'type' => 'Social', 'domains' => ['www.snapchat.com']], ['name' => 'SoundCloud', 'type' => 'Social', 'domains' => ['soundcloud.com']], ['name' => 'Stack Overflow', 'type' => 'Social', 'domains' => ['stackoverflow.com']], ['name' => 'Startpage', 'type' => 'Search', 'domains' => ['www.startpage.com']], ['name' => 'StumbleUpon', 'type' => 'Social', 'domains' => ['www.stumbleupon.com']], ['name' => 'Telegram', 'type' => 'Social', 'domains' => ['telegram.org']], ['name' => 'Threads', 'type' => 'Social', 'domains' => ['threads.com', 'l.threads.com']], ['name' => 'Weibo', 'type' => 'Social', 'domains' => ['weibo.com']], ['name' => 'Tumblr', 'type' => 'Social', 'domains' => ['www.tumblr.com']], ['name' => 'Twitch', 'type' => 'Social', 'domains' => ['www.twitch.tv']], ['name' => 'Vimeo', 'type' => 'Social', 'domains' => ['vimeo.com']], ['name' => 'WeChat', 'type' => 'Social', 'domains' => ['www.wechat.com']], ['name' => 'WhatsApp', 'type' => 'Social', 'domains' => ['www.whatsapp.com']], ['name' => 'Udemy', 'type' => 'Social', 'domains' => ['www.udemy.com']], ['name' => '500px', 'type' => 'Social', 'domains' => ['500px.com']], ['name' => 'WordPress.org', 'type' => 'Social', 'domains' => ['wordpress.org', 'ru.wordpress.org', 'ca.wordpress.org', 'fr.wordpress.org', 'pl.wordpress.org', 'id.wordpress.org', 'ur.wordpress.org', 'bn.wordpress.org', 'ja.wordpress.org', 'pt.wordpress.org', 'it.wordpress.org', 'hy.wordpress.org', 'hi.wordpress.org', 'de.wordpress.org', 'ar.wordpress.org', 'es.wordpress.org', 'cn.wordpress.org', 'en-ca.wordpress.org', 'en-gb.wordpress.org']], ['name' => 'ChatGPT', 'type' => 'AI', 'domains' => ['chatgpt.com']], ['name' => 'Perplexity', 'type' => 'AI', 'domains' => ['perplexity.ai']], ['name' => 'Gemini', 'type' => 'AI', 'domains' => ['gemini.google.com']], ['name' => 'Bard', 'type' => 'AI', 'domains' => ['bard.google.com']], ['name' => 'Copilot', 'type' => 'AI', 'domains' => ['copilot.microsoft.com']], ['name' => 'Claude', 'type' => 'AI', 'domains' => ['claude.ai']], ['name' => 'DeepSeek', 'type' => 'AI', 'domains' => ['deepseek.com']], ['name' => 'Hugging Face', 'type' => 'AI', 'domains' => ['huggingface.co']], ['name' => 'Grok', 'type' => 'AI', 'domains' => ['grok.com']]];
    public static function get_group_for(string $domain) : ?array
    {
        foreach (self::$referrers as $referrer) {
            if (\in_array($domain, $referrer['domains'])) {
                return ['domain' => \reset($referrer['domains']), 'type' => $referrer['type'], 'name' => $referrer['name']];
            }
        }
        return null;
    }
    public static function referrers() : array
    {
        return self::$referrers;
    }
    public static function replace_known_referrers_table()
    {
        global $wpdb;
        $referrer_groups_table = \IAWP\Query::get_table_name(\IAWP\Query::REFERRER_GROUPS);
        $known_referrers = self::referrers();
        $wpdb->query("DELETE FROM {$referrer_groups_table}");
        foreach ($known_referrers as $group) {
            foreach ($group['domains'] as $domain) {
                $wpdb->insert($referrer_groups_table, ['name' => $group['name'], 'domain' => $group['domains'][0], 'domain_to_match' => $domain, 'type' => $group['type']]);
            }
        }
    }
}
